document.addEventListener('DOMContentLoaded', function () {
    const menuWrap = document.getElementById('adminmenuwrap');
    if (menuWrap) {
        const logoContainer = document.createElement('div');
        logoContainer.id = 'custom-admin-logo';
        logoContainer.innerHTML = `
            <img src="${admin_script_vars.logo_url}" alt="لوگو" />
        `;
        menuWrap.insertBefore(logoContainer, menuWrap.firstChild);
    }
});



jQuery(document).ready(function($) {

    function applySavedColor() {
        var savedColorClass = localStorage.getItem('wdashAdminMenuColorClass');

        if (savedColorClass) {
            $('#adminmenuwrap, #wpadminbar').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-orginal wdash-default-color').addClass(savedColorClass);
        }
    }

    applySavedColor();

    $('.wdash-set-color').on('click', function() {
        var colorClass = $(this).data('color-class');

        $('#adminmenuwrap, #wpadminbar').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-orginal wdash-default-color');

        $('#adminmenuwrap, #wpadminbar').addClass(colorClass);

        localStorage.setItem('wdashAdminMenuColorClass', colorClass);
    });
});

jQuery(document).ready(function($) {

    function applySavedMenuItemColor() {
        var savedMenuItemColorClass = localStorage.getItem('wdashAdminMenuItemColorClass');

        if (savedMenuItemColorClass) {
            $('#adminmenu li.current > a.menu-top, #adminmenu li.wp-has-current-submenu > a.menu-top').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-default-color wdash-orginal').addClass(savedMenuItemColorClass);
        }
    }

    applySavedMenuItemColor();

    $('.wdash-set-color-menu').on('click', function() {
        var menuItemColorClass = $(this).data('color-class');

        // حذف تمام کلاس‌های رنگی قبلی فقط از آیتم‌های فعال
        $('#adminmenu li.current > a.menu-top, #adminmenu li.wp-has-current-submenu > a.menu-top').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-orginal wdash-default-color');

        // اضافه کردن کلاس رنگی جدید فقط به آیتم‌های فعال
        $('#adminmenu li.current > a.menu-top, #adminmenu li.wp-has-current-submenu > a.menu-top').addClass(menuItemColorClass);

        localStorage.setItem('wdashAdminMenuItemColorClass', menuItemColorClass);
    });
});



jQuery(document).ready(function($) {

    function applySavedSubMenuItemColor() {
        var savedSubMenuItemColorClass = localStorage.getItem('wdashAdminSubMenuItemColorClass');

        if (savedSubMenuItemColorClass) {
            $('#adminmenu .wp-submenu').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-default-color wdash-orginal').addClass(savedSubMenuItemColorClass);
        }
    }

    applySavedSubMenuItemColor();

    $('.wdash-set-color-submenu').on('click', function() {
        var subMenuItemColorClass = $(this).data('color-class');

        $('#adminmenu .wp-submenu').removeClass('wdash-color-1 wdash-color-2 wdash-color-3 wdash-color-4 wdash-color-5 wdash-color-6 wdash-orginal wdash-default-color');

        $('#adminmenu .wp-submenu').addClass(subMenuItemColorClass);

        localStorage.setItem('wdashAdminSubMenuItemColorClass', subMenuItemColorClass);
    });
});