<?php

/**
 * Plugin Name: WDash Dashboard Style
 * Plugin URI: https://www.yourwebsite.com/wdash-dashboard-style/
 * Description: با وی دش استایل داشبوردت رو عوض کن و به راحتی وبسایت رو مدیریت کن هرماه وی دش امکانات جدید برات فراهم می کنه یادت باشه که زود به زود بروز نگهش دای.
 * Version: 1.0.0
 * Author: AmirHosein Rashidi
 * Author URI: https://portfolio-amirrashidi.vercel.app
 * License: GPL2
 * Text Domain: wdash-dashboard-style
 * Domain Path: /languages/
 */



defined('ABSPATH') or die('No script kiddies please!');

function load_translation()
{
    load_plugin_textdomain('wdash-custom-admin-sidebar', false, dirname(plugin_basename(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'load_translation');

function wdash_enqueue_custom_admin_sidebar_assets()
{
    wp_enqueue_style('dashboard-style-css', plugin_dir_url(__FILE__) . 'css/dashboard-style.css');
    wp_enqueue_script('dashboard-js', plugin_dir_url(__FILE__) . 'js/dashboard.js', array(), null, true);

    wp_localize_script('dashboard-js', 'admin_script_vars', array(
        'logo_url' => plugin_dir_url(__FILE__) . 'logo.png'
    ));
}

add_action('admin_enqueue_scripts', 'wdash_enqueue_custom_admin_sidebar_assets');

function wdash_enqueue_custom_login_assets()
{
    wp_enqueue_style('login-styles-css', plugin_dir_url(__FILE__) . 'css/login-style.css');
}
add_action('login_enqueue_scripts', 'wdash_enqueue_custom_login_assets');

function your_plugin_login_header_url()
{
    return home_url();
}
add_filter('login_headerurl', 'your_plugin_login_header_url');

function your_plugin_login_header_title()
{
    return get_bloginfo('name');
}
add_filter('login_headertitle', 'your_plugin_login_header_title');
function wdash_add_settings_page_to_sidebar()
{
    add_menu_page(
        __('تنظیمات وی دش', 'wdash-custom-admin-sidebar'),
        __('وی دش', 'wdash-custom-admin-sidebar'),
        'manage_options',
        'wdash_settings',
        'wdash_render_settings_page',
        'dashicons-before',
        8
    );
}
add_action('admin_menu', 'wdash_add_settings_page_to_sidebar');
function wdash_admin_enqueue_styles($hook)
{
    if ($hook == 'toplevel_page_wdash_settings') {
        wp_enqueue_style('wdash-admin-styles', plugin_dir_url(__FILE__) . 'css/dashboard-style.css');
    }
}
add_action('admin_enqueue_scripts', 'wdash_admin_enqueue_styles');

function wdash_render_settings_page()
{
?>
    <div class="wrap">
        <h1><?php esc_html_e('تنظیمات استایل وی دش', 'wdash-custom-admin-sidebar'); ?></h1>
        <p class="hi-text"><?php esc_html_e('👋🏻 سلام دوست من به وی دش خوش آمدی بریم استایل رو خوشگل کنیم  ', 'wdash-custom-admin-sidebar'); ?></p>
        <p><?php esc_html_e('انتخاب رنگ سایدبار:', 'wdash-custom-admin-sidebar'); ?></p>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-1" style="background-color: #1c00a6 !important;" title="<?php esc_html_e('آبی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-2" style="background-color: #000000 !important;" title="<?php esc_html_e('سبز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-3" style="background-color: #ef7000 !important;" title="<?php esc_html_e('نارنجی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-4" style="background-color: #9b59b6 !important;" title="<?php esc_html_e('بنفش', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-5" style="background-color:#333  !important;" title="<?php esc_html_e('خاکستری تیره', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-color-6" style="background-color: #c0392b !important;" title="<?php esc_html_e('قرمز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-default-color" style="background-color:rgb(73, 73, 73) !important;" title=""></button>
        <button class="button wdash-set-color color-preview" data-color-class="wdash-orginal" style="background-color: #000f36  !important;"></button>
        <p><?php esc_html_e('انتخاب رنگ منو آیتم ها :', 'wdash-custom-admin-sidebar'); ?></p>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-1" style="background-color: #1c00a6 !important;" title="<?php esc_html_e('آبی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-2" style="background-color: #000000 !important;" title="<?php esc_html_e('سبز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-3" style="background-color: #ef7000 !important;" title="<?php esc_html_e('نارنجی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-4" style="background-color: #9b59b6 !important;" title="<?php esc_html_e('بنفش', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-5" style="background-color:#333  !important;" title="<?php esc_html_e('خاکستری تیره', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-color-6" style="background-color: #c0392b !important;" title="<?php esc_html_e('قرمز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-default-color" style="background-color:rgb(73, 73, 73) !important;" title=""></button>
        <button class="button wdash-set-color-menu color-preview" data-color-class="wdash-orginal" style="background-color: #2c01ff !important;"></button>
        <p><?php esc_html_e('انتخاب رنگ زیر منو ها :', 'wdash-custom-admin-sidebar'); ?></p>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-1" style="background-color: #1c00a6 !important;" title="<?php esc_html_e('آبی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-2" style="background-color: #000000 !important;" title="<?php esc_html_e('سبز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-3" style="background-color: #ef7000 !important;" title="<?php esc_html_e('نارنجی', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-4" style="background-color: #9b59b6 !important;" title="<?php esc_html_e('بنفش', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-5" style="background-color:#333  !important;" title="<?php esc_html_e('خاکستری تیره', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-color-6" style="background-color: #c0392b !important;" title="<?php esc_html_e('قرمز', 'wdash-custom-admin-sidebar'); ?>"></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-default-color" style="background-color:rgb(73, 73, 73) !important;" title=""></button>
        <button class="button wdash-set-color-submenu color-preview" data-color-class="wdash-orginal" style="background-color: #2c01ff !important;"></button>
    </div>

<?php
}
?>